<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('avatar')->nullable()->after('email');
            $table->integer('api_credits')->default(1000)->after('avatar');
            $table->integer('api_calls_today')->default(0)->after('api_credits');
            $table->integer('api_calls_month')->default(0)->after('api_calls_today');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['avatar', 'api_credits', 'api_calls_today', 'api_calls_month']);
        });
    }
};
