<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Plan and subscription
            if (!Schema::hasColumn('users', 'plan_id')) {
                $table->foreignId('plan_id')->nullable()->after('email')->constrained()->nullOnDelete();
            }
            if (!Schema::hasColumn('users', 'plan_expires_at')) {
                $table->timestamp('plan_expires_at')->nullable()->after('plan_id');
            }
            
            // Credits - may already exist
            if (!Schema::hasColumn('users', 'credits')) {
                $table->integer('credits')->default(0)->after('plan_expires_at');
            }
            
            // Usage limits - may already exist
            if (!Schema::hasColumn('users', 'api_calls_today')) {
                $table->integer('api_calls_today')->default(0)->after('credits');
            }
            if (!Schema::hasColumn('users', 'api_calls_reset_date')) {
                $table->date('api_calls_reset_date')->nullable()->after('api_calls_today');
            }
            
            // Status
            if (!Schema::hasColumn('users', 'is_active')) {
                $table->boolean('is_active')->default(true)->after('api_calls_reset_date');
            }
            if (!Schema::hasColumn('users', 'last_activity_at')) {
                $table->timestamp('last_activity_at')->nullable()->after('is_active');
            }
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Only drop if they exist
            if (Schema::hasColumn('users', 'plan_id')) {
                $table->dropForeign(['plan_id']);
                $table->dropColumn('plan_id');
            }
            $columns = ['plan_expires_at', 'is_active', 'last_activity_at'];
            foreach ($columns as $column) {
                if (Schema::hasColumn('users', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
