<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_cost_settings', function (Blueprint $table) {
            $table->id();
            $table->string('endpoint')->unique();
            $table->string('category'); // serp, keywords, backlinks, onpage, etc.
            $table->string('name'); // Human-readable name
            $table->decimal('cost_per_request', 10, 4)->default(0.0001);
            $table->decimal('cost_per_result', 10, 6)->default(0);
            $table->integer('credit_cost')->default(1); // Internal credit cost
            $table->boolean('is_active')->default(true);
            $table->text('description')->nullable();
            $table->timestamps();

            $table->index('category');
        });

        // Add more fields to api_logs for better tracking
        Schema::table('api_logs', function (Blueprint $table) {
            $table->string('category')->nullable()->after('endpoint');
            $table->decimal('actual_cost', 10, 6)->default(0)->after('credits_used');
            $table->integer('results_count')->default(0)->after('actual_cost');
            $table->string('status')->default('success')->after('status_code');
            $table->text('error_message')->nullable()->after('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('api_logs', function (Blueprint $table) {
            $table->dropColumn(['category', 'actual_cost', 'results_count', 'status', 'error_message']);
        });
        
        Schema::dropIfExists('api_cost_settings');
    }
};
